//
// DataFileToObjectParser.m

#import "DataFileToObjectParser.h"

@implementation XMLToObjectParser


- (NSArray *)items
{
	return items;
}


- (id)parseXMLAtURL:(NSURL *)url 
		   toObject:(NSString *)aClassName 
		 parseError:(NSError **)error
{
	[items release];
	items = [[NSMutableArray alloc] init];
	NameOfClass = aClassName;

    NSXMLParser *parser = [[NSXMLParser alloc] initWithContentsOfURL:url];
    
	[parser setDelegate:self];
	
	[parser parse];
	
	if([parser parserError] && error) {
		*error = [parser parserError];
	}
    [parser release];
	return self;
}


- (void)parser:(NSXMLParser *)parser
didStartElement:(NSString *)element
  namespaceURI:(NSString *)namespaceURI
 qualifiedName:(NSString *)qName
	attributes:(NSDictionary *)attributeDict
{	
	if([element isEqualToString:NameOfClass]) {
		item = [[NSClassFromString(NameOfClass) alloc] init];
	}
	else {
		CurrentNode = [element copy];
		CNodeContent = [[NSMutableString alloc] init];
	}
}


- (void)parser:(NSXMLParser *)parser 
 didEndElement:(NSString *)element
  namespaceURI:(NSString *)namespaceURI
 qualifiedName:(NSString *)qName

{	
	if([element isEqualToString:NameOfClass]) {
		[items addObject:item];
		[item release];
		item = nil;
	}
	else if([element isEqualToString:CurrentNode]) {     
		[item setValue:CNodeContent forKey:element];
		
		[CNodeContent release];
		CNodeContent = nil;
		
		[CurrentNode release];
		CurrentNode = nil;
	}
}


- (void)parser:(NSXMLParser *)parser
foundCharacters:(NSString *)string
{   
	[CNodeContent appendString:string];
}


- (void)dealloc
{
	[items release];
	[super dealloc];
}

@end
